<?php
session_start();
require_once("./motores/interno/funciones.php");
require_once("./motores/interno/validador.php");
require_once("./motores/interno/formatos.php");
require_once("./motores/interno/defs.php");
require_once("./motores/interno/MasterCat.class.php");
$catalogo = new Catalogo('migrante', "P", null, "form-control");	//Sirve para crear el arreglo de la tabla principal
$explab = new Catalogo('cv_experiencia_laboral', 'D', $catalogo->getConexion(), 'form-control');
$idiomas = new Catalogo('idioma_migrante', 'D', $catalogo->getConexion(), 'form-control');
$contacto = new Catalogo('migrante_contacto', 'D', $catalogo->getConexion(), 'form-control');
//La siguiente línea define un catálogo detalle, asignar el nombre de la tabla y descomentariar para usar
?>
<!DOCTYPE html>
<html>
	<head>
		<title><?= NOMBRE_APLICACION ?> -- Bienvenido, <?= $_SESSION['Usuario']['nombre']; ?></title>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" >
		<meta charset="utf-8">
		<!-- SEO Meta Tags -->
		<meta name="description" content="Descripción" />
		<meta name="keywords" content="Palabras Clave" />
		<meta name="author" content="CarpathiaLab" />
		<!-- Mobile Specific Meta Tag -->
		<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
		<!-- Favicon Icon -->
		<script src="js/jquery.min.js"></script>
		<script src="js/jquery-ui.min.js"></script>
		<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?&libraries=places&language=es&key=AIzaSyBWe3yPvnEk__zqa04SH0UlDqsjGG_TBWs"></script>
		<link rel="shortcut icon" href="favicon.ico" type="image/x-icon">
		<link rel="icon" href="favicon.ico" type="image/x-icon">
		<!--CSS-->
		<link rel="stylesheet" type="text/css" href="css/style.css" />
		<link rel="stylesheet" type="text/css" href="css/tether.min.css" />
		<link rel="stylesheet" type="text/css" href="css/bootstrap.min.css" />
		<link rel="stylesheet" type="text/css" href="css/personalizado.css" />
		<link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet"/>
		<link rel="stylesheet" href="css/jquery-ui.min.css" />
		<?= $catalogo->getScripts() ?>
		<?= $explab->getScripts() ?>
		<?= $idiomas->getScripts() ?>
		<?= $contacto->getScripts() ?>
		<script type="text/javascript">
			var tinyMCE = undefined;
			function validapwd(forma = 'p') {
				txtPwd = (forma == 'p' ? document.getElementById('p1') : document.getElementById('pa1'));
				txtPwd2 = (forma == 'p' ? document.getElementById('p2') : document.getElementById('pa2'));
				ctrlPwd = (forma == 'p' ? document.getElementById('elpass') : document.getElementById('elpassa'));
				var color = '';
				if (txtPwd2.value == '') {
					//Aún no se escribe nada en el segundo campo... pasamos
					ctrlPwd.value = '';
				}else if (txtPwd.value != txtPwd2.value) {
					color = '#fe6e6e';
					ctrlPwd.value = '';
				} else {
					color = '#9ffec2';
					ctrlPwd.value = txtPwd.value;
				}
				txtPwd.style.backgroundColor = color;
				txtPwd2.style.backgroundColor = color;
			}
			function editaUsr(id) {
				//alert("Editando usuario " + id);
				$("#aeUsr").val("<?= ofusca('1id'); ?>|"+id);
				var datos = {t: "<?= ofusca('usuario'); ?>",l: "<?= ofusca('email') ?>", c: "<?= ofusca('id'); ?>|" + id, r: "c"};
				$("#idu").val(id);
				$.ajax({
					url: "./motores/hanumat.php",
					type: "POST",
					dataType: "JSON",
					data: datos
				}).done(function (r) {
					if (r.error == "0") {
						$("#usuario").val(r.registros[0].email);
					} else {
						console.log(r.errmsg);
					}
				});
			}
			function dibuja(datos) {
				//console.log($("#frmAlta").serialize());
				$("#vista").html("");
				var contenido = "";
				var hdr = '<tr>';
				for (var i = 0; i < datos.length; i++) {
					contenido += '<tr>';
					for (var llave in datos[i]) {
						if (datos[i].hasOwnProperty(llave)) {
							if (i == 0) {
								//Ponemos los encabezados
								if (llave.substr(0, 2) != "id") hdr += '<th>' + llave + '</th>';
							}
							if (llave.substr(0, 2) != "id") contenido += '<td>' + datos[i][llave] + '</td>';
						}
					}
					contenido += '<td><button class="btn btn-primary" onclick="imprime(\'' + datos[i]["idusuario"] + '\')" title="Vista previa"><i class="material-icons align-middle">print</i></button><button title="Modificar" class="btn btn-success" onclick="migrante.edita(\'' + datos[i]["idusuario"] + '\')" data-toggle="modal" data-target="#agregaCliente"><i class="material-icons align-middle">edit</i></button><button title="Cambiar contraseña" class="btn btn-danger" onclick="cambiaPwd(\'' + datos[i]["idusuario"] + '\', this)" data-toggle="modal" data-target="#cambiaPwd"><i class="material-icons align-middle">vpn_key</i></button></td></tr>';
				}
				hdr += '<th style="min-width: 210px;">Herramientas</th>';
				contenido = '<table class="table table-striped">' + hdr + '</tr>' + contenido + '</table>';
				$("#vista").html(contenido);
			}
			function errorDatos() {
				console.log("Hubo bronquitas con los datos");
			}
			function inicia() {
				migrante.busca();
				migrante.ubica();
			}
			function guardalo() {
				var datos = {r: 'dameID', ae: $("#aeUsr").val()};
				datos['<?= ofusca("usuario[email]"); ?>'] = $("#usuario").val();
				datos['<?= ofusca("usuario[nombrecompleto]"); ?>'] = document.getElementById('<?= ofusca('migrante_nombre') ?>').value + ' ' + document.getElementById('<?= ofusca('migrante_paterno') ?>').value + ' ' + document.getElementById('<?= ofusca('migrante_materno') ?>').value;
				datos["<?= ofusca('usuario[idrol]'); ?>"] = "1";
				if ($("#elpass").val() != "") {
					datos['<?= ofusca("usuario[passwd]"); ?>'] = $("#elpass").val();
				}
				$.ajax({
					url: "./motores/hanumat.php",
					type: "POST",
					dataType: 'JSON',
					data: datos
				}).done(function (r) {
					if (r.error == "0") {
						if (r.hasOwnProperty("id") && $("#ae").val() == "") $("#idu").val(r.id); else $("#idu").attr("name", "");
						agregaRegistro();
					}
				});
			}
			function agregaRegistro() {
				$.ajax({
					url: "motores/hanumat.php",
					type: "POST",
					dataType: "JSON",
					data: $("#frmAlta").serialize()
				}).done(function (r) {
					if (r.error == '0') {
						$("#mensaje").html("<div class='alert alert-success'> Grabado correctamente </div>");
						setTimeout(function(){
							migrante.limpia();
							$("#mensaje").html('');
							$("#agregaCliente").modal("hide");
						}, 1500);
						migrante.busca();
					}else {
						$("#mensaje").html("<div class='alert alert-danger'> Error al guardar, puede volver a intentar en unos momentos </div>");
						setTimeout(function(){
							$("#mensaje").html('');
						}, 1500);
						console.log(r.errmsg);
					}
				});
			}
			function doLogout() {
				$.ajax({
					url : "motores/hanumat.php",
					type : "POST",
					dataType : "JSON",
					data : {r: 's'}
				}).done(function(r) {
					if (r.error == '0') {
						window.location.reload();
					}
				});
				//limpiaDers();
				return false;
			}
			$(document).ready( function () {
				$(".limpia" ).click(function(e) {
					$("#frmAlta")[0].reset();
				});
			});
			function editaDetalle(id) {
				cv_experiencia_laboral.editaDetalle(id);
				idioma_migrante.editaDetalle(id);
				migrante_contacto.editaDetalle(id);
				editaUsr(id);
			}
			function dibujaDetalle(obj, tbl) {
				var fila = '<tr>';
				for (var prop in obj) {
					if (obj[prop] != '-1') {
						if (obj[prop].indexOf("cache||") != -1) {
							fila += '<td><img src="' + $("#vprevias img")[0].src + '" style="max-width: 300px; max-height: 300px;"></td>';
							$("#vprevias img")[0].src = "";
							document.getElementById("tmp" + prop).disabled = false;
						} else if (obj[prop].indexOf("data:image") != -1) {
							fila += '<td><img src="' + obj[prop] + '" style="max-width: 300px; max-height: 300px;"></td>';
						} else {
							fila += '<td>' + obj[prop] + '</td>';
						}
					}
				}
				fila += '<td><p class="btn btn-danger" role="button" onclick="'+tbl+'.quitadetalle(\'tbl'+tbl+'\', this)"> - </p></td></tr>';
				$("#tbl"+tbl).append(fila);
			}
			function limpiaDetalle() {
				cv_experiencia_laboral.resetDetalle();
				idioma_migrante.resetDetalle();
				migrante_contacto.resetDetalle();
			}
			function imprime(id) {
				$("#impu").val('<?= ofusca('imprimecv.php|-|Letter'); ?>||'+id);
				$("#frmImprime").submit();
			}
			function cambiaPwd(id) {
				$("#idPwd").val("<?= ofusca('1id'); ?>|" + id);
			}
			function doCambiaPwd() {
				$.ajax({
					url: "motores/hanumat.php",
					type: "POST",
					dataType: "JSON",
					data: $("#frmPwd").serialize()
				}).done(function (r) {
					if (r.error == '0') {
						$("#mensajePwd").html("<div class='alert alert-success'> Se actualizó la contraseña! </div>");
						setTimeout(function(){
							$("#mensajePwd").html('');
							$("#cambiaPwd").modal("hide");
						}, 1500);
					} else {
						$("#mensaje").html("<div class='alert alert-danger'> Error al guardar, puede volver a intentar en unos momentos </div>");
						setTimeout(function(){
							$("#mensajePwd").html('');
						}, 1500);
						console.log(r.errmsg);
					}
				});
			}
		</script>
	</head>
	<body onload="inicia()">
		<header>
			<nav id="herramientas" class="navbar navbar-toggleable-md"  style="background-color: rgba(50, 47, 47, 0.73); height:120px;">
				<?= dameMenuApp(); ?>
			</nav>
		</header>
		<!-- Intro Section -->
		<section class="intro" style="background-image: url(img/fondo2.jpg); min-height: 60%;"></section>
		</section>
		<section style="position: absolute; z-index:1; min-width:100%; padding-bottom: 50px;">
			<div class="container" style=" margin-top:30px;">
				<div class="row">
					<div class="col-md-12 col-sm-12">
						<div class="row rounded fondo-gris1">
							<div class=" rounded" style="width: 100%;background-color: rgba(50, 47, 47, 0.73); margin:8px;">
								<div class="col-md-12 col-sm-12" style="margin-top:40px;">
									<h3 style="color:#eaa704;">Buscar una persona</h3>
									<input type="text" id="txtBusca" class="col-md-8 form-control" placeholder=" Buscar ">
									<div class="col-md-2">
										<span class="input-group-btn">
											<button class="btn btn-default"  onclick="migrante.busca()" id="btnBusca" type="button"> <i class="material-icons align-middle">search</i> </button>
										</span>
									</div>
									<div class="col-md-2">
										<a href="#"  id="nuevo" class="btn btn-success pull-right" data-toggle="modal" data-target="#agregaCliente" role="button"> <i class="material-icons align-middle">add_circle</i> Agregar</a>
									</div>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="fondo-gris1 rounded col-md-12">
								<div class="oferta rounded">
									<H2 class="mb-4">Migrantes registrados</H2>
									<div class="well well-lg color-well table-responsive">
										<div id="vista"></div>
										<div id="paginas"></div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
		<footer class="text-center fixed-bottom" style="background-color: rgba(50, 47, 47, 0.73); height: 30px;">
			<p>©Datametrix 2018</p>
		</footer>
		<!--modal para agregar almacenamientos-->
		<div id="cambiaPwd" class="modal fade" tabindex="-2" role="dialog" aria-labelledby="cambiaPwdLabel" aria-hidden="true">
			<div class="modal-dialog fondo" style="min-width: 50%;">
				<div class="modal-content">
					<div class="modal-header">
						<h5>Cambiar contraseña</h5>
						<button type="button" class="close limpia" data-dismiss="modal">&times;</button>
					</div>
					<div class="modal-body">
						<div id="mensajePwd"></div>
						<div id="frmPassword">
							<form id="frmPwd">
								<table border="0">
									<tr>
										<td>Contraseña</td>
										<td>
											<input type="password" id="pa1" onchange="validapwd('s')" />
											<input type="hidden" id="elpassa" name="<?= ofusca('usuario[passwd]'); ?>" />
										</td>
									</tr>
									<tr>
										<td>Confirmar</td>
										<td><input type="password" id="pa2" onchange="validapwd('s')" /></td>
									</tr>
								</table>
								<input type="hidden" id="idPwd" name="ae" />
								<input type="hidden" name="r" value="invalido" />
							</form>
						</div>
					</div>
					<div class="modal-footer">
						<button type="button" class="limpia btn btn-default" data-dismiss="modal">Cancelar</button>
						<a href="javascript:void(0)" class="btn btn-primary" onclick="doCambiaPwd()">Agregar</a>
					</div>

				</div>
			</div>
		</div>
		<div id="agregaCliente" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="agregaClienteLabel" aria-hidden="true">
			<div class="modal-dialog fondo" style="min-width: 90%;">
				<!--Modal content-->
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">CV y perfil de la persona</h5>
						<button type="button" class="close limpia" data-dismiss="modal">&times;</button>
					</div>
					<div class="modal-body">
						<div id="mensaje"></div>
						<div id="forma">
							<form id="frmAlta">
								<table border="0">
									<tr>
										<td colspan="2"><h3>Datos de acceso</h3></td>
									</tr>
									<tr>
										<td>Correo electrónico</td>
										<td><input type="email" id="usuario" class="form-control" /></td>
									</tr>
									<tr>
										<td>Contraseña</td>
										<td>
											<input type="password" id="p1" onchange="validapwd('p')" />
											<input type="hidden" id="elpass" value=""/>
										</td>
									</tr>
									<tr>
										<td>Confirmar</td>
										<td><input type="password" id="p2" onchange="validapwd('p')" /></td>
									</tr>
									<tr>
										<td colspan="2"><h3>Datos personales</h3></td>
									</tr>
									<?= $catalogo->comoTabla(); ?>
									<tr>
										<td colspan="2"><h3>Datos de contacto</h3></td>
									</tr>
									<tr>
										<?= $contacto->comoTabla(); ?>
									</tr>
									<tr>
										<td colspan="2"><h3>Idiomas que domina</h3></td>
									</tr>
									<tr>
										<?= $idiomas->comoTabla(); ?>
									</tr>
									<tr>
										<td colspan="2"><h3>Experiencia laboral</h3></td>
									</tr>
									<tr>
										<?= $explab->comoTabla(); ?>
									</tr>
								</table>
								<!-- Cambiar el siguiente campo para cambiar la página de regreso -->
								<input type="hidden" value="-1" id="idu" name="<?= ofusca('migrante[idusuario]'); ?>" />
								<input type="hidden" name="<?= ofusca('migrante[idcreador]'); ?>" value="<?= $_SESSION['Usuario']['id'] ?>"/>
								<input type="hidden" name="r" value="migrantes.php"/>
								<input type="hidden" name="ae" value="" id="ae" />
							</form>
							<input type="hidden" name="aeUsr" value="" id="ae" />
						</div>
					</div>
					<div class="modal-footer">
						<button type="button" class="limpia btn btn-default" onclick="migrante.limpia()" data-dismiss="modal">Cancelar</button>
						<a href="javascript:void(0)" class="btn btn-primary" onclick="guardalo()">Agregar</a>
					</div>
				</div>
			</div>
		</div>
		<form id="frmImprime" action="./motores/tlacuilo.php" method="post" target="_blank">
			<input type="hidden" value="" id="impu" name="t" />
		</form>
		<script src="js/popper.js"></script>
		<script src="js/tether.min.js"></script>
		<script src="js/bootstrap.min.js"></script>
		<script src="js/plugins/jquery.magnific-popup.min.js"></script>
	</body>
</html>