<?php
session_start();
require_once("./motores/interno/funciones.php");
require_once("./motores/interno/validador.php");
require_once("./motores/interno/formatos.php");
require_once("./motores/interno/defs.php");
require_once("./motores/interno/MasterCat.class.php");
$catalogo = new Catalogo('migrante', "P", null, "form-control");	//Sirve para crear el arreglo de la tabla principal
$explab = new Catalogo('cv_experiencia_laboral', 'D', $catalogo->getConexion(), 'from-control');
$idiomas = new Catalogo('idioma_migrante', 'D', $catalogo->getConexion(), 'form-control');
$contacto = new Catalogo('migrante_contacto', 'D', $catalogo->getConexion(), 'form-control');
?>
<!DOCTYPE html>
<html>
	<head>
		<title><?= NOMBRE_APLICACION ?> -- Bienvenido, <?= $_SESSION['Usuario']['nombre']; ?></title>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" >
		<meta charset="utf-8">
		<!-- SEO Meta Tags -->
		<meta name="description" content="Descripción" />
		<meta name="keywords" content="Palabras Clave" />
		<meta name="author" content="CarpathiaLab" />

		<!-- Mobile Specific Meta Tag -->
		<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
		<!-- Favicon Icon -->
		<script src="js/jquery.min.js"></script>
		<script src="js/jquery-ui.min.js"></script>
		<link rel="shortcut icon" href="favicon.ico" type="image/x-icon">
		<link rel="icon" href="favicon.ico" type="image/x-icon">
		<!--CSS-->
		<link rel="stylesheet" type="text/css" href="css/style.css" />
		<link rel="stylesheet" type="text/css" href="css/bootstrap.min.css" />
		<link rel="stylesheet" type="text/css" href="css/personalizado.css" />
		<link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet"/>
		<link rel="stylesheet" href="css/jquery-ui.min.css" />
		<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?&libraries=places&language=es&key=AIzaSyBWe3yPvnEk__zqa04SH0UlDqsjGG_TBWs"></script>
		<?= $catalogo->getScripts(); ?>
		<?= $explab->getScripts() ?>
		<?= $idiomas->getScripts() ?>
		<?= $contacto->getScripts() ?>
		<script type="text/javascript">
			var tinyMCE = undefined;
			function agregaRegistro() {
				$.ajax({
					url: "motores/hanumat.php",
					type: "POST",
					dataType: "JSON",
					data: $("#frmAlta").serialize()
				}).done(function (r) {
					if (r.error == '0') {
						window.location.href = r.destino;
					}else {
						$("#mensaje").html("<div class='alert alert-danger'> Error al guardar </div>");
						setTimeout(function(){
							$("#mensaje").html('');
						}, 3000);
					}
				});
			}
			function doLogout() {
				$.ajax({
					url : "motores/hanumat.php",
					type : "POST",
					dataType : "JSON",
					data : {
						r : 's'
					}
				}).done(function(r) {
					if (r.error == '0') {
						window.location.reload();
					}
				});
				//limpiaDers();
				return false;
			}
			function inicia() {
				migrante.edita(<?= $_SESSION['Usuario']['id'] ?>);
				migrante.ubica();
			}
			function editaDetalle(id) {
				cv_experiencia_laboral.editaDetalle(id);
				idioma_migrante.editaDetalle(id);
				migrante_contacto.editaDetalle(id);
			}
			function dibujaDetalle(obj, tbl) {
				var fila = '<tr>';
				for (var prop in obj) {
					if (obj[prop] != '-1') {
						if (obj[prop].indexOf("cache||") != -1) {
							fila += '<td><img src="' + $("#vprevias img")[0].src + '" style="max-width: 300px; max-height: 300px;"></td>';
							$("#vprevias img")[0].src = "";
							document.getElementById("tmp" + prop).disabled = false;
						} else if (obj[prop].indexOf("data:image") != -1) {
							fila += '<td><img src="' + obj[prop] + '" style="max-width: 300px; max-height: 300px;"></td>';
						} else {
							fila += '<td>' + obj[prop] + '</td>';
						}
					}
				}
				fila += '<td><p class="btn btn-danger btn-round" role="button" onclick="'+tbl+'.quitadetalle(\'tbl'+tbl+'\', this)"> - </p></td></tr>';
				$("#tbl"+tbl).append(fila);
			}
			function limpiaDetalle() {
				cv_experiencia_laboral.resetDetalle();
				idioma_migrante.resetDetalle();
				migrante_contacto.editaDetalle();
			}
			function imprime() {
				$("#frmImprime").submit();
			}
		</script>
	</head>
	<body onload="inicia()">
		<header>
			<nav id="herramientas" class="navbar navbar-toggleable-md"  style="background-color: rgba(50, 47, 47, 0.73); height:120px;">
				<?= dameMenuMigrante(); ?>
			</nav>
		</header>
		<!-- Intro Section -->
		<section class="intro" style="background-image: url(img/fondo2.jpg); min-height: 60%;"></section>
		</section>
		<section style="position: absolute; z-index:1; min-width:100%;">
			<div class="container" style=" margin-top:30px;">
				<div class="row">
					<div class="col-md-12 col-sm-12">
						<div class="row rounded fondo-gris1">
							<div class=" rounded" style="width: 100%;background-color: rgba(50, 47, 47, 0.73); margin:8px;">
								<div class="col-md-12 col-sm-12" style="margin-top:40px;">
									<h3 style="color:#eaa704;">Perfil de usuario</h3>
									<button class="btn btn-warning" data-toggle="modal" data-target="#cambiaPwd" role="button">Cambiar contraseña</button>
									<button class="btn btn-primary" onclick="imprime()">Vista previa e imprimir</button>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="fondo-gris1 rounded col-md-12">
								<div class="oferta rounded">
									<form id="frmAlta" style="padding: 12px;">
										<table>
											<tr>
												<td colspan="2"><h3>Datos personales</h3></td>
											</tr>
											<?= $catalogo->comoTabla(); ?>
											<tr>
												<td colspan="2"><h3>Datos de contacto</h3></td>
											</tr>
											<tr>
												<?= $contacto->comoTabla(); ?>
											</tr>
											<tr>
												<td colspan="2"><h3>Idiomas que domina</h3></td>
											</tr>
											<tr>
												<?= $idiomas->comoTabla(); ?>
											</tr>
											<tr>
												<td colspan="2"><h3>Experiencia laboral</h3></td>
											</tr>
											<tr>
												<?= $explab->comoTabla(); ?>
											</tr>
										</table>
										<input type="hidden" id="ae" name="ae"  />
										<input type="hidden" id="r" name="r" value="landing.php" />
										<a href="#" onclick="agregaRegistro()" class="btn btn-success">¡Guardar cambios!</a>
										<a href="baja.php" class="btn btn-error">Borrar mi cuenta</a>
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
		<form id="frmImprime" action="./motores/tlacuilo.php" method="post" target="_blank">
			<input type="hidden" id="impu" name="t" value="<?= ofusca("imprimecv.php|-|Letter|-|" . $_SESSION['Usuario']['id']); ?>"/>
		</form>
		<form id="frmImprime" action="./imprimecv.php" method="post" target="_blank">
			<input type="hidden" value="<?= $_SESSION['Usuario']['id'] ?>" name="a" />
		</form>
		<footer class="text-center fixed-bottom" style="background-color: rgba(50, 47, 47, 0.73); height: 30px;">
			<p>©Datametrix 2018</p>
		</footer>
		<div id="cambiaPwd" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="agregaClienteLabel" aria-hidden="true">
			<div class="modal-dialog fondo" style="min-width: 90%;">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">Cambiar contraseña</h5>
						<button type="button" class="close limpia" data-dismiss="modal">&times;</button>
					</div>
					<div class="modal-body">
					</div>
					<div class="modal-footer">
					</div>
				</div>
			</div>
		</div>
		<script src="js/popper.js"></script>
		<script src="js/tether.min.js"></script>
		<script src="js/bootstrap.min.js"></script>
		<script src="js/plugins/jquery.magnific-popup.min.js"></script>
	</body>
</html>
